<?php
/**
 * Template part for displaying posts
 */
?>

<?php
  $content = apply_filters( 'the_content', get_the_content() );
  $audio = false;

  // Only get audio from the content if a playlist isn't present.
  if ( false === strpos( $content, 'wp-playlist-script' ) ) {
    $audio = get_media_embedded_in_content( $content, array( 'audio' ) );
  }
?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <div class="blogger">
    <h3><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title();?></a></h3>
      <?php
        if ( ! is_single() ) {

          // If not a single post, highlight the audio file.
          if ( ! empty( $audio ) ) {
            foreach ( $audio as $audio_html ) {
              echo '<div class="entry-audio">';
                echo $audio_html;
              echo '</div><!-- .entry-audio -->';
            }
          };

        };
      ?>

      <div class="text">
          <?php the_excerpt();?>
      </div>
      <div class="post-link">
        <a href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_attr_e( 'Continue Reading....','foster-charity' ); ?></a>
      </div>

    <div class="post-heading">
      <div class="row">
        <div class="col-lg-6">
          <div class="post-info">
              <i class="fa fa-user" aria-hidden="true"></i><span class="entry-author"> <?php the_author(); ?></span>
              <i class="fas fa-comments"></i><span class="entry-comments"><?php comments_number( __('0 Comments','foster-charity'), __('0 Comments','foster-charity'), __('% Comments','foster-charity') ); ?></span>             
          </div>
        </div>
        <div class="col-lg-6">
          <div class="blog-date">Posted on <?php the_time( get_option( 'date_format' ) ); ?></div>
        </div>
      </div>
    </div>
  </div>
</div>
